rollout DYNmrSunLight ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobj

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNsunParams FUNsun =
  (
    DYNmrSunLight.LOCobj = FUNsun

    if classOf FUNsun == Sun_Positioner then
    (
      DYNmrSunLight.LBDYNlightName.text       = FUNsun.name
      DYNmrSunLight.LOCobj                    = FUNsun
      DYNmrSunLight.CKDYNshowCompass.checked  = FUNsun.show_compass
      DYNmrSunLight.SPDYNsunRadius.value      = FUNsun.compass_radius
      DYNmrSunLight.SPDYNdistance.value       = FUNsun.north_direction_deg
      DYNmrSunLight.SPDYNnorthOffset.value    = FUNsun.baseObject.north_direction_deg

      if classOf environmentMap == Physical_Sun___Sky_Environment then 
      (
        DYNmrSunLight.BUDYNinstallEnv.text  = DYNuiResourcesButtons[120]
        DYNmrSunLight.BUDYNinstallEnv.enabled = false
      )
      else 
      (
        DYNmrSunLight.BUDYNinstallEnv.text  = DYNuiResourcesButtons[119]
        DYNmrSunLight.BUDYNinstallEnv.enabled = true
      )
    )
    else
    (
      for i in DYNmrSunLight.controls do i.enabled = false
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  label LBDYNlightName      align:#center

  groupbox GBDYNgroup01     pos:[4,24] width:(DYNiniExplorerWidth - 21) height:87
  checkbox CKDYNshowCompass align:#left pos:[13,45]
  label   LBDYNsunRadius    align:#left pos:[13,67]
  spinner  SPDYNsunRadius   align:#left pos:[(DYNiniExplorerWidth - 96),65] range:[-999999.0,999999.0,1.0] type:#float   fieldwidth:60 scale:1.0
  label   LBDYNnorthOffset  align:#left pos:[13,87]
  spinner SPDYNnorthOffset  align:#left pos:[(DYNiniExplorerWidth - 96),85] range:[-359.99,359.99,0.0] type:#float fieldwidth:60 scale:0.1

  groupbox GBDYNgroup02     pos:[4,116] width:(DYNiniExplorerWidth - 21) height:43
  label   LBDYNdistance     align:#left pos:[13,135]
  spinner SPDYNdistance     align:#left pos:[(DYNiniExplorerWidth - 96),133] range:[-999999.0,999999.0,1.0] type:#float fieldwidth:60 scale:0.1

  button BUDYNinstallEnv    width:(DYNiniExplorerWidth - 21) align:#center pos:[4,164]
  button BUDYNtimeDate      width:(DYNiniExplorerWidth - 21) align:#center pos:[4,188]

  on DYNmrSunLight open do
  (
    DYNmrSunLight.title   = DYNuiRolloutNames[68]
    GBDYNgroup01.text     = DYNuiResourcesGroups[67]
    GBDYNgroup02.text     = DYNuiResourcesGroups[83]

    CKDYNshowCompass.text = DYNuiResourcesLabels[22]
    LBDYNsunRadius.text   = DYNuiResourcesLabels[186]
    LBDYNdistance.text    = DYNuiResourcesLabels[663]
    LBDYNnorthOffset.text = DYNuiResourcesLabels[265]
    BUDYNtimeDate.text    = DYNuiResourcesButtons[60]
    BUDYNinstallEnv.text  = DYNuiResourcesButtons[119]
  )

  on BUDYNtimeDate pressed do
  (
    cui.commandPanelOpen = true
    max modify mode
    messagebox (DYNuiResourcesErrorsWarnings[31]) title:DYNuiResourcesTitlebars[3]
  )

  on BUDYNinstallEnv pressed do 
  (
    if classOf environmentMap != Physical_Sun___Sky_Environment then
    (
      environmentMap = Physical_Sun___Sky_Environment()
    )

    if classOf environmentMap == Physical_Sun___Sky_Environment then 
    (
      environmentMap.sun_position_object = LOCobj

      DYNmrSunLight.BUDYNinstallEnv.text  = DYNuiResourcesButtons[120]
      DYNmrSunLight.BUDYNinstallEnv.enabled = false
    )
    else 
    (
      DYNmrSunLight.BUDYNinstallEnv.text  = DYNuiResourcesButtons[119]
      DYNmrSunLight.BUDYNinstallEnv.enabled = true
    )
  )

  on CKDYNshowCompass changed arg do LOCobj.show_compass = arg
  on SPDYNsunRadius   changed arg do LOCobj.compass_radius = arg
  on SPDYNnorthOffset changed arg do LOCobj.north_direction_deg = arg
  on SPDYNdistance    changed arg do LOCobj.sun_distance = arg
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAlV1evyeku3CzP9NIkfh2KV8fg864dvHZg
-- 5TAyPp8uolLe6Fhf3EasduR3VJnGoPtrKlx0vQ3fXpZ+BZnQ8qZud1FsiGv+o7aQ
-- flRmtWl/z8m9yFmasQaYGhgUQG2GMe+WIg2TILkuYBmpVDGiHOmZGx8KqzKZi4ON
-- LNlIAQDG+dbes5SfuZmkKobfSu6PnCqFIJcS6Z3SswsAqQS/9JY9rkNe4yAF0qQ6
-- pp6MOOe+e6txUmdKZmRmelGUEx8QdLBBlLnNXsVt5aI7/fMr39EZK2kowPE29A33
-- TEVDtyqt2WFGRAoCY0MVLsQs9mH5Pm2BsjUys38YoowOd3zia5Vf
-- -----END-SIGNATURE-----